
#ifndef __SGraphicsHandle__
#define __SGraphicsHandle__

#include <Basics/CCountedObject.hpp>

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Graphics
		{
			/**
			 * @struct SGraphicsHandle SGraphicsHandle.hpp
			 * @brief Cross Platform representation of a graphics handle
			 *
			 * @date 18/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: SGraphicsHandle.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			struct SGraphicsHandle
			{
				#ifdef WIN32
					HBITMAP m_bitmap;			/**< The draw bitmap */
					HDC m_drawContext;			/**< The draw context */
				#else
					GWorldPtr m_bitmap;			/**< The bitmap */
				#endif

//	===========================================================================

				/**
				 * Check if we have a valid (not null) windowHandle
				 * @retval bool True if handle is valid, false otherwise
				 */
				bool handleIsValid()
				{
					return (m_bitmap != NULL);
				}

//	===========================================================================

			};
		}
	}
}
#endif	// End of SGraphicsHandle.hpp